
#include "Perus.h"


/*
suhteeliset nopeudet:
    -yksitellen:        1.0x
    -vertex array:      1.63x
    -VBO                4.78x
 */




void GRAFIIKKA::Alusta( int Leveys, int Korkeus )
{
    AlustaMalli3DPuskuri();

    AlustaTekstuuriPuskuri();
    
    AlustaFontit();

    ObjektienLKM = 0;
    KuvienLKM = 0;
    
    KameroidenLKM = 0;
    KAMERA VakioKamera;
    VakioKamera.HidInd = 0;
    LisaaKamera( VakioKamera );
    KytkeKamera( 0 );
    
    RuudunLeveys = Leveys;
    RuudunKorkeus = Korkeus;
    
    Osoitin.Alusta( "Osoitin", 64, 64, 0, 0, 1, 1 );
    NaytaOsoitin();
}

void GRAFIIKKA::Paivita( char *Otsikko, double HiiriX, double HiiriY, double KierrosAika  )
{

if(KierrosAika < 1000.0/72.0)
{
    for(int i=SDL_GetTicks(); i+KierrosAika > SDL_GetTicks();){}
}
if(KierrosAika <= 1000.0/72.0)
{
    if(OsoitinNakyvissa == true)
        LisaaKuva( Osoitin, HiiriX, HiiriY - Osoitin.Korkeus*3, 3);
    
    
    
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glBindTexture(GL_TEXTURE_2D, 0);
    glColor3f(1,1,1);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(70, (double)RuudunLeveys/RuudunKorkeus, 1, 30000);
    glMatrixMode(GL_MODELVIEW);
    



    glEnable(GL_DEPTH_TEST);
    /*
    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT1);
    
    float ValonSijainti[4] = {0, 5, 0, 1};
    float ValonAmbient[4] = { 0.8, 0.8, 0.8, 1};
    float ValonDiffuse[4] = { 1, 1, 1, 1};
    float ValonSpecular[4] = { 1, 1, 1, 1};
    float ValonVaimeneminen[4] = { 0.000001, 0, 0, };
    
    glLightfv(GL_LIGHT1, GL_POSITION, ValonSijainti);
    glLightfv(GL_LIGHT1, GL_AMBIENT, ValonAmbient);
    glLightfv(GL_LIGHT1, GL_DIFFUSE, ValonDiffuse);
    glLightfv(GL_LIGHT1, GL_SPECULAR, ValonSpecular);
    glLightfv(GL_LIGHT1, GL_QUADRATIC_ATTENUATION, ValonVaimeneminen);
    
    float PinnanVari[4] = { 1, 1, 1, 1};
    glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE, PinnanVari);
    */
    for(unsigned int i=0; i<ObjektienLKM; i++)
    {
        glLoadIdentity();
        glScalef(20, 20, 20);
        gluLookAt( Kamerat[AktiivinenKamera].Sijainti.X, Kamerat[AktiivinenKamera].Sijainti.Y, Kamerat[AktiivinenKamera].Sijainti.Z,
                   Kamerat[AktiivinenKamera].KatsottavanSijainti.X, Kamerat[AktiivinenKamera].KatsottavanSijainti.Y, Kamerat[AktiivinenKamera].KatsottavanSijainti.Z,
                   Kamerat[AktiivinenKamera].YlosV.X, Kamerat[AktiivinenKamera].YlosV.Y, Kamerat[AktiivinenKamera].YlosV.Z );
               
	    glTranslatef(ObjektiPuskuri[i]->Sijainti.X, ObjektiPuskuri[i]->Sijainti.Y, ObjektiPuskuri[i]->Sijainti.Z);
        glMultMatrixd( ObjektiPuskuri[i]->AsentoM.M );

        glScalef(ObjektiPuskuri[i]->Skaalaus, ObjektiPuskuri[i]->Skaalaus, ObjektiPuskuri[i]->Skaalaus);
        

        glBindTexture(GL_TEXTURE_2D, TekstuuriPuskuri[ObjektiPuskuri[i]->TekstuuriInd].ID);

        if(Malli3DPuskuri[ObjektiPuskuri[i]->Malli3DInd].OnkoVBO)
        {
            glBindBufferARB( GL_ARRAY_BUFFER_ARB, Malli3DPuskuri[ObjektiPuskuri[i]->Malli3DInd].VerteksienID );
		    glVertexPointer( 3, GL_FLOAT, 0, (char *) NULL );
            glBindBufferARB( GL_ARRAY_BUFFER_ARB, Malli3DPuskuri[ObjektiPuskuri[i]->Malli3DInd].TeksKoordienID );
            glTexCoordPointer( 2, GL_FLOAT, 0, (char *) NULL );
	    }
        else
	    {
            glVertexPointer( 3, GL_FLOAT, 0, Malli3DPuskuri[ObjektiPuskuri[i]->Malli3DInd].Verteksit );
            glTexCoordPointer( 2, GL_FLOAT, 0, Malli3DPuskuri[ObjektiPuskuri[i]->Malli3DInd].TeksKoordit );
        }

        glDrawArrays( GL_TRIANGLES, 0, Malli3DPuskuri[ObjektiPuskuri[i]->Malli3DInd].VerteksienLKM );
        
    }



    glDisable(GL_DEPTH_TEST);
    //glDisable(GL_LIGHTING);

    
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluOrtho2D( 0, 1280, 0, 1024);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    for(unsigned int i=0; i<KuvienLKM; i++)
    {
        glColor4d( KuvaPuskuri[i].Vari.R, KuvaPuskuri[i].Vari.G, KuvaPuskuri[i].Vari.B, KuvaPuskuri[i].Vari.A );
        glBindTexture(GL_TEXTURE_2D,  TekstuuriPuskuri[KuvaPuskuri[i].TekstuuriInd].ID);
        
        glBegin( GL_QUADS );
            glTexCoord2f( KuvaPuskuri[i].U1, KuvaPuskuri[i].V1 );
            glVertex2f( KuvaPuskuri[i].X, KuvaPuskuri[i].Y );

            glTexCoord2f( KuvaPuskuri[i].U2, KuvaPuskuri[i].V1 );
            glVertex2f( KuvaPuskuri[i].X + KuvaPuskuri[i].Leveys, KuvaPuskuri[i].Y );

            glTexCoord2f( KuvaPuskuri[i].U2, KuvaPuskuri[i].V2 );
            glVertex2f( KuvaPuskuri[i].X + KuvaPuskuri[i].Leveys, KuvaPuskuri[i].Y + KuvaPuskuri[i].Korkeus );

            glTexCoord2f( KuvaPuskuri[i].U1, KuvaPuskuri[i].V2 );
            glVertex2f( KuvaPuskuri[i].X, KuvaPuskuri[i].Y + KuvaPuskuri[i].Korkeus );
        glEnd();
    }



    SDL_GL_SwapBuffers();
}



    TyhjennaObjektiPuskuri();
    TyhjennaKuvaPuskuri();
    //SDL_WM_SetCaption(Otsikko, "");
}





void GRAFIIKKA::NaytaOsoitin()
{
    OsoitinNakyvissa = true;
}
void GRAFIIKKA::PiilotaOsoitin()
{
    OsoitinNakyvissa = false;
}





















